/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.client.render.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.entity.ai.goal.coppergolem.CopperGolemFleeEntityGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.coppergolem.CopperGolemLookAtEntityGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.coppergolem.CopperGolemPressButtonGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.coppergolem.CopperGolemSpinHeadGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.coppergolem.CopperGolemTemptGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.coppergolem.CopperGolemWanderAroundGoal;
import com.faboslav.friendsandfoes.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.util.ModelAnimationHelper;
import com.faboslav.friendsandfoes.util.RandomGenerator;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1427;
import net.minecraft.class_1439;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4135;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_5955;

public final class CopperGolemEntity
extends class_1427
implements AnimatedEntity {
    private static final float MOVEMENT_SPEED = 0.35f;
    private static final int COPPER_INGOT_HEAL_AMOUNT = 5;
    private static final float SPARK_CHANCE = 0.025f;
    private static final float OXIDATION_CHANCE = 2.0E-5f;
    public static final int MIN_TICKS_UNTIL_CAN_PRESS_BUTTON = 200;
    public static final int MIN_TICKS_UNTIL_NEXT_HEAD_SPIN = 150;
    public static final int MAX_TICKS_UNTIL_NEXT_HEAD_SPIN = 300;
    public static final int MIN_STRUCT_BY_LIGHTNING_TICKS = 1200;
    public static final int MAX_STRUCT_BY_LIGHTNING_TICKS = 2400;
    private static final String OXIDATION_LEVEL_NBT_NAME = "OxidationLevel";
    private static final String IS_WAXED_NBT_NAME = "IsWaxed";
    private static final String BUTTON_PRESS_ANIMATION_PROGRESS_NBT_NAME = "ButtonPressAnimationProgress";
    private static final String LAST_BUTTON_PRESS_ANIMATION_PROGRESS_NBT_NAME = "LastButtonPressAnimationProgress";
    private static final String HEAD_SPIN_ANIMATION_PROGRESS_NBT_NAME = "HeadSpinAnimationProgress";
    private static final String LAST_HEAD_SPIN_ANIMATION_PROGRESS_NBT_NAME = "LastHeadSpinAnimationProgress";
    private static final String ENTITY_SNAPSHOT_NBT_NAME = "EntitySnapshot";
    private static final class_2940<Integer> OXIDATION_LEVEL = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> STRUCT_BY_LIGHTNING_TICKS = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_WAXED = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_PRESSING_BUTTON = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_SPINNING_HEAD;
    private static final class_2940<Boolean> IS_MOVING;
    private static final class_2940<Integer> TICKS_UNTIL_CAN_PRESS_BUTTON;
    private static final class_2940<Integer> TICKS_UNTIL_NEXT_HEAD_SPIN;
    private static final class_2940<Float> BUTTON_PRESS_ANIMATION_PROGRESS;
    private static final class_2940<Float> LAST_BUTTON_PRESS_ANIMATION_PROGRESS;
    private static final class_2940<Float> HEAD_SPIN_ANIMATION_PROGRESS;
    private static final class_2940<Float> LAST_HEAD_SPIN_ANIMATION_PROGRESS;
    private static final class_2940<class_2487> ENTITY_SNAPSHOT;
    private static final Predicate<class_1297> NOTICEABLE_PLAYER_FILTER;
    public CopperGolemPressButtonGoal pressButtonGoal;
    private AnimationContextTracker animationContextTracker;

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.animationContextTracker = new AnimationContextTracker();
        }
        return this.animationContextTracker;
    }

    public CopperGolemEntity(class_1299<? extends CopperGolemEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6013 = 0.3f;
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new CopperGolemFleeEntityGoal((class_1314)this, class_1657.class, 16.0f, this.method_6029(), this.method_6029(), entity -> NOTICEABLE_PLAYER_FILTER.test((class_1297)((class_1657)entity)) && this.isWaxed()));
        this.pressButtonGoal = new CopperGolemPressButtonGoal(this);
        this.field_6201.method_6277(2, (class_1352)this.pressButtonGoal);
        this.field_6201.method_6277(3, (class_1352)new CopperGolemTemptGoal(this, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_20414})));
        this.field_6201.method_6277(4, (class_1352)new CopperGolemSpinHeadGoal(this));
        this.field_6201.method_6277(6, (class_1352)new CopperGolemWanderAroundGoal(this));
        this.field_6201.method_6277(7, (class_1352)new CopperGolemLookAtEntityGoal((class_1308)this, CopperGolemEntity.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new CopperGolemLookAtEntityGoal((class_1308)this, class_1439.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new CopperGolemLookAtEntityGoal((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(OXIDATION_LEVEL, (Object)class_5955.class_5811.field_28704.ordinal());
        this.field_6011.method_12784(STRUCT_BY_LIGHTNING_TICKS, (Object)0);
        this.field_6011.method_12784(IS_WAXED, (Object)false);
        this.field_6011.method_12784(IS_PRESSING_BUTTON, (Object)false);
        this.field_6011.method_12784(TICKS_UNTIL_CAN_PRESS_BUTTON, (Object)RandomGenerator.generateInt(200, 400));
        this.field_6011.method_12784(IS_SPINNING_HEAD, (Object)false);
        this.field_6011.method_12784(IS_MOVING, (Object)false);
        this.field_6011.method_12784(TICKS_UNTIL_NEXT_HEAD_SPIN, (Object)RandomGenerator.generateInt(150, 300));
        this.field_6011.method_12784(BUTTON_PRESS_ANIMATION_PROGRESS, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(LAST_BUTTON_PRESS_ANIMATION_PROGRESS, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(HEAD_SPIN_ANIMATION_PROGRESS, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(LAST_HEAD_SPIN_ANIMATION_PROGRESS, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(ENTITY_SNAPSHOT, (Object)new class_2487());
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569(OXIDATION_LEVEL_NBT_NAME, this.getOxidationLevel().ordinal());
        nbt.method_10548(BUTTON_PRESS_ANIMATION_PROGRESS_NBT_NAME, this.getButtonPressAnimationProgress());
        nbt.method_10548(LAST_BUTTON_PRESS_ANIMATION_PROGRESS_NBT_NAME, this.getLastButtonPressAnimationProgress());
        nbt.method_10548(HEAD_SPIN_ANIMATION_PROGRESS_NBT_NAME, this.getHeadSpinAnimationProgress());
        nbt.method_10548(LAST_HEAD_SPIN_ANIMATION_PROGRESS_NBT_NAME, this.getLastHeadSpinAnimationProgress());
        nbt.method_10556(IS_WAXED_NBT_NAME, this.isWaxed());
        nbt.method_10566(ENTITY_SNAPSHOT_NBT_NAME, (class_2520)this.getEntitySnapshot());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setOxidationLevel(class_5955.class_5811.values()[nbt.method_10550(OXIDATION_LEVEL_NBT_NAME)]);
        this.setIsWaxed(nbt.method_10577(IS_WAXED_NBT_NAME));
        this.setButtonPressAnimationProgress(nbt.method_10583(BUTTON_PRESS_ANIMATION_PROGRESS_NBT_NAME));
        this.setLastButtonPressAnimationProgress(nbt.method_10583(LAST_BUTTON_PRESS_ANIMATION_PROGRESS_NBT_NAME));
        this.setHeadSpinAnimationProgress(nbt.method_10583(HEAD_SPIN_ANIMATION_PROGRESS_NBT_NAME));
        this.setLastHeadSpinAnimationProgress(nbt.method_10583(LAST_HEAD_SPIN_ANIMATION_PROGRESS_NBT_NAME));
        this.setEntitySnapshot(nbt.method_10562(ENTITY_SNAPSHOT_NBT_NAME));
        this.applyEntitySnapshot();
    }

    public void setEntitySnapshot(class_2487 entitySnapshot) {
        this.field_6011.method_12778(ENTITY_SNAPSHOT, (Object)entitySnapshot);
    }

    public void applyEntitySnapshot() {
        class_2487 entitySnapshot = this.getEntitySnapshot();
        if (entitySnapshot.method_33133()) {
            return;
        }
        this.field_6284 = entitySnapshot.method_10574("serverYaw");
        this.field_5982 = entitySnapshot.method_10583("prevYaw");
        this.method_36456(this.field_5982);
        this.field_6004 = entitySnapshot.method_10583("prevPitch");
        this.field_6221 = this.field_6004;
        this.method_36457(this.field_6004);
        this.field_6239 = entitySnapshot.method_10550("roll");
        this.field_6283 = this.field_6220 = entitySnapshot.method_10583("prevBodyYaw");
        this.field_6242 = entitySnapshot.method_10574("serverHeadYaw");
        this.field_6241 = this.field_6259 = entitySnapshot.method_10583("prevHeadYaw");
        this.field_6251 = this.field_6229 = entitySnapshot.method_10583("lastHandSwingProgress");
        this.field_6225 = this.field_6211 = entitySnapshot.method_10583("lastLimbDistance");
        this.field_6249 = entitySnapshot.method_10583("limbAngle");
        this.field_6255 = this.field_6275 = entitySnapshot.method_10583("prevLookDirection");
        this.field_6012 = entitySnapshot.method_10550("age");
        this.field_6233 = this.field_6217 = entitySnapshot.method_10583("prevStepBobbingAmount");
    }

    public class_2487 getEntitySnapshot() {
        return (class_2487)this.field_6011.method_12789(ENTITY_SNAPSHOT);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, (double)0.35f).method_26868(class_5134.field_23718, 1.0);
    }

    protected void method_6087(class_1297 entity) {
        if (this.isOxidized()) {
            return;
        }
        super.method_6087(entity);
    }

    protected int method_6130(int air) {
        return air;
    }

    public float method_6017() {
        return (this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.2f + 2.5f;
    }

    protected class_3414 method_6011(class_1282 source) {
        return FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_HURT.get();
    }

    protected class_3414 method_6002() {
        return FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_DEATH.get();
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (this.isOxidized() || state.method_26207().method_15797()) {
            return;
        }
        class_2680 blockState = this.method_37908().method_8320(pos.method_10084());
        class_2498 blockSoundGroup = blockState.method_26164(class_3481.field_28040) ? blockState.method_26231() : state.method_26231();
        this.method_5783(FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_STEP.get(), blockSoundGroup.method_10597() * 0.15f, this.method_6017());
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_5529() instanceof class_1538 || source == class_1282.field_16992) {
            return false;
        }
        if (!this.method_37908().method_8608() && this.pressButtonGoal.isRunning()) {
            this.pressButtonGoal.method_6270();
        }
        boolean damageResult = super.method_5643(source, amount);
        if (this.isOxidized()) {
            class_2487 entitySnapshot = this.getEntitySnapshot();
            this.field_6225 = this.field_6211 = entitySnapshot.method_10583("lastLimbDistance");
            this.field_6249 = entitySnapshot.method_10583("limbAngle");
        }
        return damageResult;
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)this.method_5751() * 0.45, 0.0);
    }

    protected float method_18394(class_4050 poseIn, class_4048 sizeIn) {
        return 0.75f;
    }

    public float method_6029() {
        if (this.isStructByLightning()) {
            return 0.525f;
        }
        return 0.35f - (float)this.getOxidationLevel().ordinal() * 0.05f;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 itemInHand = itemStack.method_7909();
        boolean interactionResult = false;
        if (itemInHand == class_1802.field_27022) {
            interactionResult = this.tryToInteractMobWithCopperIngot(player, itemStack);
        } else if (itemInHand == class_1802.field_20414) {
            interactionResult = this.tryToInteractMobWithHoneycomb(player, itemStack);
        } else if (itemInHand instanceof class_1743) {
            interactionResult = this.tryToInteractMobWithAxe(player, hand, itemStack);
        }
        if (interactionResult) {
            this.method_32875(class_5712.field_28725, (class_1297)this);
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        return super.method_5992(player, hand);
    }

    private boolean tryToInteractMobWithCopperIngot(class_1657 player, class_1799 itemStack) {
        if (this.method_6032() == this.method_6063()) {
            return false;
        }
        this.method_6025(5.0f);
        if (!player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        this.method_5783(FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_REPAIR.get(), 1.0f, this.method_6017() - 1.0f);
        return true;
    }

    private boolean tryToInteractMobWithHoneycomb(class_1657 player, class_1799 itemStack) {
        if (this.isWaxed() || this.isOxidized()) {
            return false;
        }
        this.setIsWaxed(true);
        if (!player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        this.method_5783(class_3417.field_29543, 1.0f, 1.0f);
        this.spawnParticles((class_2394)class_2398.field_29642, 7);
        return true;
    }

    private boolean tryToInteractMobWithAxe(class_1657 player, class_1268 hand, class_1799 itemStack) {
        if (!this.isWaxed() && !this.isDegraded()) {
            return false;
        }
        if (this.isWaxed()) {
            this.setIsWaxed(false);
            this.method_5783(class_3417.field_29542, 1.0f, 1.0f);
            this.spawnParticles((class_2394)class_2398.field_29643, 7);
        } else if (this.isDegraded()) {
            if (!this.method_5770().method_8608()) {
                int increasedOxidationLevelOrdinal = this.getOxidationLevel().ordinal() - 1;
                class_5955.class_5811[] OxidationLevels = class_5955.class_5811.values();
                this.setOxidationLevel(OxidationLevels[increasedOxidationLevelOrdinal]);
            }
            this.method_5783(class_3417.field_29541, 1.0f, 1.0f);
            this.spawnParticles((class_2394)class_2398.field_29645, 7);
        }
        if (!this.method_37908().method_8608() && !player.method_31549().field_7477) {
            itemStack.method_7956(1, (class_1309)player, playerEntity -> player.method_20236(hand));
        }
        return true;
    }

    public void method_5773() {
        if (!FriendsAndFoes.getConfig().enableCopperGolem) {
            this.method_31472();
        }
        super.method_5773();
        if (this.isOxidized()) {
            this.applyEntitySnapshot();
            return;
        }
        if (this.isStructByLightning() && !this.method_5770().method_8608()) {
            this.setStructByLightningTicks(this.getStructByLightningTicks() - 1);
            if (RandomGenerator.generateRandomFloat() < 0.025f) {
                for (int i = 0; i < 7; ++i) {
                    ((class_3218)this.field_6002).method_14199((class_2394)class_2398.field_29644, this.method_23322(0.35), this.method_23319() + 0.25, this.method_23325(0.35), 1, this.method_6051().method_43059() * 0.01, this.method_6051().method_43059() * 0.01, this.method_6051().method_43059() * 0.01, 0.1);
                }
            }
        }
        if (this.getTicksUntilCanPressButton() > 0) {
            this.setTicksUntilCanPressButton(this.getTicksUntilCanPressButton() - 1);
        }
        if (this.getTicksUntilNextHeadSpin() > 0) {
            this.setTicksUntilNextHeadSpin(this.getTicksUntilNextHeadSpin() - 1);
        }
        this.updateButtonPressAnimation();
        this.updateHeadSpinAnimation();
        if (!this.method_37908().method_8608()) {
            this.setIsMoving(this.method_5942().method_23966());
        }
        if (!this.isWaxed()) {
            this.handleOxidationIncrease();
        }
    }

    public void method_6091(class_243 movementInput) {
        if (!this.isOxidized()) {
            super.method_6091(movementInput);
            return;
        }
        if (this.method_5770().method_8608()) {
            return;
        }
        this.applyGravityToTravel(movementInput);
    }

    private void applyGravityToTravel(class_243 movementInput) {
        boolean bl;
        double d = 0.08;
        boolean bl2 = bl = this.method_18798().field_1351 <= 0.0;
        if (bl && this.method_6059(class_1294.field_5906)) {
            d = 0.01;
            this.method_38785();
        }
        if (!this.method_6128()) {
            class_2338 blockPos = this.method_23314();
            float p = this.method_37908().method_8320(blockPos).method_26204().method_9499();
            float f = this.method_24828() ? p * 0.91f : 0.91f;
            class_243 vec3d6 = this.method_26318(movementInput, p);
            double q = vec3d6.field_1351;
            if (this.method_6059(class_1294.field_5902)) {
                q += (0.05 * (double)(this.method_6112(class_1294.field_5902).method_5578() + 1) - vec3d6.field_1351) * 0.2;
                this.method_38785();
            } else if (this.method_37908().method_8608() && !this.method_37908().method_22340(blockPos)) {
                q = this.method_23318() > (double)this.method_37908().method_31607() ? -0.1 : 0.0;
            } else if (!this.method_5740()) {
                q -= d;
            }
            if (this.method_35053()) {
                this.method_18800(vec3d6.field_1352, q, vec3d6.field_1350);
            } else {
                this.method_18800(vec3d6.field_1352 * (double)f, q * (double)0.98f, vec3d6.field_1350 * (double)f);
            }
        }
    }

    public void method_5842() {
        super.method_5842();
        if (this.isOxidized()) {
            this.applyEntitySnapshot();
        }
    }

    public void method_5800(class_3218 serverWorld, class_1538 lightning) {
        super.method_5800(serverWorld, lightning);
        this.method_20803(0);
        this.method_33572(false);
        this.method_6033(this.method_6063());
        if (this.isDegraded()) {
            this.spawnParticles((class_2394)class_2398.field_29643, 7);
        }
        if (!this.method_5770().method_8608()) {
            this.refreshStructByLightningTicks();
            if (!this.isWaxed()) {
                this.setOxidationLevel(class_5955.class_5811.field_28704);
            }
        }
    }

    private void updateButtonPressAnimation() {
        this.setLastButtonPressAnimationProgress(this.getButtonPressAnimationProgress());
        if (this.isPressingButton()) {
            this.setButtonPressAnimationProgress(Math.min(1.0f, this.getButtonPressAnimationProgress() + 0.2f));
        } else {
            this.setButtonPressAnimationProgress(Math.max(0.0f, this.getButtonPressAnimationProgress() - 0.2f));
        }
    }

    private void updateHeadSpinAnimation() {
        this.setLastHeadSpinAnimationProgress(this.getHeadSpinAnimationProgress());
        if (this.isSpinningHead()) {
            this.setHeadSpinAnimationProgress(Math.min(1.0f, this.getHeadSpinAnimationProgress() + 0.075f));
        } else {
            this.setHeadSpinAnimationProgress(0.0f);
        }
    }

    public void handleOxidationIncrease() {
        if (this.method_5770().method_8608() || this.isOxidized() || this.isWaxed()) {
            return;
        }
        if (RandomGenerator.generateRandomFloat() < 2.0E-5f) {
            int degradedOxidationLevelOrdinal = this.getOxidationLevel().ordinal() + 1;
            class_5955.class_5811[] OxidationLevels = class_5955.class_5811.values();
            this.setOxidationLevel(OxidationLevels[degradedOxidationLevelOrdinal]);
        }
    }

    public boolean isOxidized() {
        return this.getOxidationLevel() == class_5955.class_5811.field_28707;
    }

    public boolean isDegraded() {
        return this.getOxidationLevel().ordinal() > class_5955.class_5811.field_28704.ordinal();
    }

    public class_5955.class_5811 getOxidationLevel() {
        return class_5955.class_5811.values()[(Integer)this.field_6011.method_12789(OXIDATION_LEVEL)];
    }

    public void setOxidationLevel(class_5955.class_5811 OxidationLevel) {
        this.field_6011.method_12778(OXIDATION_LEVEL, (Object)OxidationLevel.ordinal());
        if (this.isOxidized() && !this.method_5987()) {
            this.becomeStatue();
        } else if (!this.isOxidized() && this.method_5987()) {
            this.becomeEntity();
        }
    }

    public void setStructByLightningTicks(int structByLightningTicks) {
        this.field_6011.method_12778(STRUCT_BY_LIGHTNING_TICKS, (Object)structByLightningTicks);
    }

    public int getStructByLightningTicks() {
        return (Integer)this.field_6011.method_12789(STRUCT_BY_LIGHTNING_TICKS);
    }

    public void refreshStructByLightningTicks() {
        this.setStructByLightningTicks(RandomGenerator.generateInt(1200, 2400));
    }

    public boolean isStructByLightning() {
        return this.getStructByLightningTicks() > 0;
    }

    private void becomeStatue() {
        class_2487 entitySnapshot = this.takeEntitySnapshot();
        this.setEntitySnapshot(entitySnapshot);
        this.method_5977(true);
        for (class_4135 goal : this.field_6201.method_19048().toList()) {
            goal.method_6270();
        }
        this.method_5942().method_6344(0.0);
        this.method_5942().method_6340();
        this.method_5962().method_6239(this.method_23317(), this.method_23318(), this.method_23321(), 0.0);
        this.method_5962().method_6240();
        this.method_5988().method_20248(this.method_5988().method_6225(), this.method_5988().method_6227(), this.method_5988().method_6228());
        this.method_5988().method_6231();
        this.field_23807 = false;
        this.field_6282 = false;
        this.method_6125(0.0f);
        this.field_6039 = 0.0f;
        this.field_5973 = 0.0f;
        this.field_6212 = 0.0f;
        this.field_6227 = 0.0f;
        this.method_18799(class_243.field_1353);
        this.field_6007 = true;
    }

    private void becomeEntity() {
        this.method_5977(false);
        this.field_23807 = true;
    }

    private class_2487 takeEntitySnapshot() {
        class_2487 entitySnapshot = new class_2487();
        entitySnapshot.method_10549("serverYaw", this.field_6284);
        entitySnapshot.method_10548("prevYaw", this.field_5982);
        entitySnapshot.method_10549("serverPitch", this.field_6221);
        entitySnapshot.method_10548("prevPitch", this.field_6004);
        entitySnapshot.method_10569("roll", this.method_6003());
        entitySnapshot.method_10548("prevBodyYaw", this.field_6220);
        entitySnapshot.method_10549("serverHeadYaw", this.field_6242);
        entitySnapshot.method_10548("prevHeadYaw", this.field_6259);
        entitySnapshot.method_10548("lastHandSwingProgress", this.field_6229);
        entitySnapshot.method_10548("lastLimbDistance", this.field_6211);
        entitySnapshot.method_10548("limbAngle", this.field_6249);
        entitySnapshot.method_10548("prevLookDirection", this.field_6275);
        entitySnapshot.method_10569("age", this.field_6012);
        entitySnapshot.method_10548("tickDelta", ModelAnimationHelper.getTickDelta());
        entitySnapshot.method_10548("prevStepBobbingAmount", this.field_6217);
        return entitySnapshot;
    }

    public boolean isWaxed() {
        return (Boolean)this.field_6011.method_12789(IS_WAXED);
    }

    public void setIsWaxed(boolean isWaxed) {
        this.field_6011.method_12778(IS_WAXED, (Object)isWaxed);
    }

    public boolean isPressingButton() {
        return (Boolean)this.field_6011.method_12789(IS_PRESSING_BUTTON);
    }

    public void setIsPressingButton(boolean isPressingButton) {
        this.field_6011.method_12778(IS_PRESSING_BUTTON, (Object)isPressingButton);
    }

    public int getTicksUntilCanPressButton() {
        return (Integer)this.field_6011.method_12789(TICKS_UNTIL_CAN_PRESS_BUTTON);
    }

    public void setTicksUntilCanPressButton(int ticksUntilCanPressButton) {
        this.field_6011.method_12778(TICKS_UNTIL_CAN_PRESS_BUTTON, (Object)ticksUntilCanPressButton);
    }

    public boolean isSpinningHead() {
        return (Boolean)this.field_6011.method_12789(IS_SPINNING_HEAD);
    }

    public void setIsSpinningHead(boolean isSpinningHead) {
        this.field_6011.method_12778(IS_SPINNING_HEAD, (Object)isSpinningHead);
    }

    public boolean isMoving() {
        return (Boolean)this.field_6011.method_12789(IS_MOVING);
    }

    public void setIsMoving(boolean isMoving) {
        this.field_6011.method_12778(IS_MOVING, (Object)isMoving);
    }

    public int getTicksUntilNextHeadSpin() {
        return (Integer)this.field_6011.method_12789(TICKS_UNTIL_NEXT_HEAD_SPIN);
    }

    public void setTicksUntilNextHeadSpin(int ticksUntilNextHeadSpin) {
        this.field_6011.method_12778(TICKS_UNTIL_NEXT_HEAD_SPIN, (Object)ticksUntilNextHeadSpin);
    }

    public float getButtonPressAnimationProgress() {
        return ((Float)this.field_6011.method_12789(BUTTON_PRESS_ANIMATION_PROGRESS)).floatValue();
    }

    public void setButtonPressAnimationProgress(float buttonPressAnimationProgress) {
        this.field_6011.method_12778(BUTTON_PRESS_ANIMATION_PROGRESS, (Object)Float.valueOf(buttonPressAnimationProgress));
    }

    public float getLastButtonPressAnimationProgress() {
        return ((Float)this.field_6011.method_12789(LAST_BUTTON_PRESS_ANIMATION_PROGRESS)).floatValue();
    }

    public void setLastButtonPressAnimationProgress(float lastButtonPressAnimationProgress) {
        this.field_6011.method_12778(LAST_BUTTON_PRESS_ANIMATION_PROGRESS, (Object)Float.valueOf(lastButtonPressAnimationProgress));
    }

    public float getHeadSpinAnimationProgress() {
        return ((Float)this.field_6011.method_12789(HEAD_SPIN_ANIMATION_PROGRESS)).floatValue();
    }

    public void setHeadSpinAnimationProgress(float headSpinAnimationProgress) {
        this.field_6011.method_12778(HEAD_SPIN_ANIMATION_PROGRESS, (Object)Float.valueOf(headSpinAnimationProgress));
    }

    public float getLastHeadSpinAnimationProgress() {
        return ((Float)this.field_6011.method_12789(LAST_HEAD_SPIN_ANIMATION_PROGRESS)).floatValue();
    }

    public void setLastHeadSpinAnimationProgress(float lastHeadSpinAnimationProgress) {
        this.field_6011.method_12778(LAST_HEAD_SPIN_ANIMATION_PROGRESS, (Object)Float.valueOf(lastHeadSpinAnimationProgress));
    }

    public void spawnParticles(class_2394 particleEffect, int amount) {
        class_1937 world = this.method_37908();
        if (world.method_8608()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((class_3218)world).method_14199(particleEffect, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 1, this.method_6051().method_43059() * 0.02, this.method_6051().method_43059() * 0.02, this.method_6051().method_43059() * 0.02, 1.0);
        }
    }

    public void setSpawnYaw(float yaw) {
        this.field_6284 = yaw;
        this.field_5982 = yaw;
        this.method_36456(yaw);
        this.field_6220 = yaw;
        this.field_6283 = yaw;
        this.field_6242 = yaw;
        this.field_6259 = yaw;
        this.field_6241 = yaw;
    }

    static {
        TICKS_UNTIL_CAN_PRESS_BUTTON = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13327);
        IS_SPINNING_HEAD = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13323);
        IS_MOVING = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13323);
        TICKS_UNTIL_NEXT_HEAD_SPIN = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13327);
        BUTTON_PRESS_ANIMATION_PROGRESS = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13320);
        LAST_BUTTON_PRESS_ANIMATION_PROGRESS = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13320);
        HEAD_SPIN_ANIMATION_PROGRESS = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13320);
        LAST_HEAD_SPIN_ANIMATION_PROGRESS = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13320);
        ENTITY_SNAPSHOT = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13318);
        NOTICEABLE_PLAYER_FILTER = entity -> {
            class_1657 player = (class_1657)entity;
            class_1799 itemStack = player.method_5998(class_1268.field_5808);
            class_1792 itemInHand = itemStack.method_7909();
            return itemInHand instanceof class_1743 && class_1301.field_6156.test(player);
        };
    }
}

